/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sedonac.Compiler;
import sedonac.analysis.BasicBlock;
import sedonac.analysis.CfgStep;
import sedonac.analysis.ControlFlowGraph;
import sedonac.ast.Expr;
import sedonac.ast.Stmt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AssignmentAnalysis
extends CfgStep {
    private boolean changed;
    private Map blockMap;
    protected CfgStep.DefinedSets curBlockSets;

    public final void run() {
        this.preAnalyze();
        this.analyzeAssignments();
        this.postAnalyze();
    }

    protected void preAnalyze() {
    }

    protected void postAnalyze() {
    }

    protected void analyzeAssignments() {
        int n = 0;
        this.changed = true;
        while (this.changed) {
            ++n;
            this.changed = false;
            Iterator iterator = this.cfg.reversePostorderIterator();
            while (iterator.hasNext()) {
                BasicBlock basicBlock = (BasicBlock)iterator.next();
                this.curBlockSets = this.getBlockSets(basicBlock);
                if (this.curBlockSets == null) {
                    this.changed |= true;
                    this.curBlockSets = new CfgStep.DefinedSets();
                    this.blockMap.put(basicBlock, this.curBlockSets);
                }
                this.computeAssignedIn(basicBlock);
                this.analyzeBlock(basicBlock);
                this.computeAssignedOut();
            }
        }
    }

    protected final CfgStep.DefinedSets getBlockSets(BasicBlock basicBlock) {
        return (CfgStep.DefinedSets)this.blockMap.get(basicBlock);
    }

    protected final void computeAssignedIn(BasicBlock basicBlock) {
        if (basicBlock == this.cfg.entry()) {
            return;
        }
        int n = basicBlock.backEdges.size();
        CfgStep.DefinedSets definedSets = null;
        HashSet hashSet = null;
        int n2 = 0;
        while (n2 < n) {
            BasicBlock basicBlock2 = (BasicBlock)basicBlock.backEdges.get(n2);
            if (basicBlock2 != basicBlock && (definedSets = this.getBlockSets(basicBlock2)) != null) {
                if (hashSet == null) {
                    hashSet = new HashSet(definedSets.defOut);
                } else {
                    this.intersect(hashSet, definedSets.defOut);
                }
                if (hashSet.isEmpty()) break;
            }
            ++n2;
        }
        if (hashSet.size() != this.curBlockSets.defIn.size()) {
            this.changed |= true;
            this.curBlockSets.defIn = hashSet;
        } else {
            Iterator iterator = this.curBlockSets.defIn.iterator();
            while (iterator.hasNext()) {
                if (hashSet.contains(iterator.next())) continue;
                this.changed |= true;
                this.curBlockSets.defIn = hashSet;
                break;
            }
        }
    }

    protected final void computeAssignedOut() {
        this.curBlockSets.defOut = new HashSet(this.curBlockSets.defIn);
        if (!this.curBlockSets.defAt.isEmpty()) {
            this.curBlockSets.defOut.addAll(this.curBlockSets.defAt);
        }
    }

    protected void localDefStmt(Stmt.LocalDef localDef) {
        if (localDef.init != null) {
            this.curBlockSets.defAt.add(localDef);
        }
        super.localDefStmt(localDef);
    }

    protected void forEachStmt(Stmt.Foreach foreach) {
        this.curBlockSets.defAt.add(foreach.local);
        super.forEachStmt(foreach);
    }

    protected void assignExpr(Expr.Binary binary) {
        switch (binary.lhs.id) {
            case 60: {
                Expr.Local local = (Expr.Local)binary.lhs;
                this.doExpr(binary.rhs);
                this.curBlockSets.defAt.add(local.def);
                break;
            }
            case 64: {
                this.doExpr(binary.lhs);
                this.doExpr(binary.rhs);
                break;
            }
            case 59: 
            case 63: {
                this.doExpr(binary.rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled assignment: " + binary.lhs.id + ' ' + binary + '\n' + binary.loc);
            }
        }
    }

    protected final boolean intersect(Set set, Set set2) {
        if (set.isEmpty()) {
            return false;
        }
        if (set2 == null || set2.isEmpty()) {
            set.clear();
            return true;
        }
        boolean bl = false;
        Object[] objectArray = set.toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (!set2.contains(objectArray[n])) {
                bl |= true;
                set.remove(objectArray[n]);
            }
            ++n;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.blockMap = new HashMap();
    }

    public AssignmentAnalysis(Compiler compiler, ControlFlowGraph controlFlowGraph) {
        super(compiler, controlFlowGraph);
        this.this();
    }
}

